### FedAtt

FedAtt is a server aggregation algorithm, where client updates were aggregated using a layer-wise attention-based mechanism that considered the similarity between the server and client models. The objective was to improve the accuracy or perplexity of the trained model with the same number of communication rounds. In its implementation in `examples/server_aggregation/fedatt/fedatt_algorithm.py`, the default implementation of `aggregate_weights()` is overridden to implement FedAtt as a custom server aggregation algorithm.

```bash
cd examples/server_aggregation/fedatt
uv run fedatt.py -c fedatt_FashionMNIST_lenet5.yml
```

**Reference:** S. Ji, S. Pan, G. Long, X. Li, J. Jiang, Z. Huang. "[Learning Private Neural Language Modeling with Attentive Aggregation](https://arxiv.org/abs/1812.07108)," in Proc. International Joint Conference on Neural Networks (IJCNN), 2019.

---

### FedAdp

FedAdp is another server aggregation algorithm, which exploited the implicit connection between data distribution on a client and the contribution from that client to the global model, measured at the server by inferring gradient information of participating clients. In its implementation in `examples/server_aggregation/fedadp/fedadp_server.py`, the default implementation in `aggregate_deltas()` is overridden to implement FedAdp as a custom server aggregation algorithm.

```bash
cd examples/server_aggregation/fedadp/
uv run fedadp.py -c fedadp_FashionMNIST_lenet5.yml
```

**Reference:** H. Wu, P. Wang. "[Fast-Convergent Federated Learning with Adaptive Weighting](https://ieeexplore.ieee.org/abstract/document/9442814)," in IEEE Trans. on Cognitive Communications and Networking (TCCN), 2021.
